#!/usr/bin/env bash
set -e  # Force bash to crash if there is an error

if ! hash vainfo 2>/dev/null; then
  echo "The 'vainfo' command is not installed! Please run install.sh and try again." >&2
  exit 1
fi

export LIBVA_DRIVERS_PATH=./lib/dri
export LD_LIBRARY_PATH=./lib:${LD_LIBRARY_PATH}

# Check if vainfo runs with an error code. If so, the device likely does not
# support VA-API.
if ! vainfo >/dev/null; then
  export LIBVA_DRIVER_NAME="fakedrivername"
  echo "Warning: VA-API appears to be unsupported. Disabling hardware video decoding." >&2
fi

# Theming
export QT_QPA_PLATFORMTHEME=gtk2

# Check if running in ubuntu
. /etc/os-release
if [ $NAME == "Ubuntu" ]; then
    export GSETTINGS_SCHEMA_DIR=/usr/share/glib-2.0/schemas
fi

# @todo: Upgrade to GTK 3.0
# This is a hack to remove warning messages due to running gtk 2.0 theme engine on Ubuntu2024 w/ gtk 3.0 
./lib/BrainFrameClient $@  2> >(grep -v -e "Unable to locate theme engine in module_path:" -e "^$" >&2)
